/*
Candidate Number - J1918

13th May 1997

Practical 2
===========
*/
    import java.applet.*;
    import java.awt.*;

    public class TurtlePower extends Applet
    {
      Turtle t;

      public void init()
      {
	t = new Turtle(100,100,0);
	t.resize(400,400);
	add(t);

	add(new Button("Square"));
        add(new Button("Hexagon"));
	add(new Button("Move"));
	add(new Button("Rotate"));
      }

      public boolean action(Event evt, Object arg)
      {
	if (arg.equals("Square"))
	{
	  TurtleSquare ts = new TurtleSquare(20);
	  ts.draw(t);
	}
        else if (arg.equals("Hexagon"))
        {
	  TurtleHexagon th = new TurtleHexagon(20);
	  th.draw(t);
	}
        else if (arg.equals("Move"))
        {
	  t.move(10);
	}
        else if (arg.equals("Rotate"))
        {
	  t.turn(45);
	}
        return true;
      }
    }

    interface TurtleInterface
    {
      public void move(int distance);
      public void turn(int degrees);
      public void jump(int distance);
      public void jumpTo(int x, int y);
    }

    interface TurtleProgram
    {
      public void draw(Turtle t);
    }

    class Turtle extends Canvas implements TurtleInterface
    {
      private int x, y, angle, xnew, ynew;

      Turtle(int x, int y, int angle)
      {
	this.x = x;
	this.y = y;
	this.angle = angle;
      }

      public void move(int distance)
      {
	Graphics g = getGraphics();

	xnew = x + (int)(distance * Math.sin(angle*Math.PI / 180));
	ynew = y - (int)(distance * Math.cos(angle*Math.PI / 180));
        g.drawLine(x,y,xnew,ynew);
	x = xnew;
	y = ynew;
      }

      public void turn(int degrees)
      {
	angle = angle + degrees;
      }

      public void jump(int distance)
      {
	x = x + (int)(distance * Math.sin(angle*Math.PI / 180));
	y = y - (int)(distance * Math.cos(angle*Math.PI / 180));
      }

      public void jumpTo(int x, int y)
      {
	this.x = x;
	this.y = y;
      }
    }

    class TurtleSquare implements TurtleProgram
    {
      private int size;

      public TurtleSquare(int size)
      {
	this.size = size;
      }

      public void draw(Turtle t)
      {
	// t.jumpTo(x,y);
	t.turn(90);
	t.move(size);
	t.turn(90);
	t.move(size);
	t.turn(90);
	t.move(size);
	t.turn(90);
	t.move(size);
      }
    }

    class TurtleHexagon implements TurtleProgram
    {
      private int size;

      public TurtleHexagon(int size)
      {
	this.size = size;
      }

      public void draw(Turtle t)
      {
	// t.jumpTo(x,y);
	t.turn(60);
	t.move(size);
	t.turn(60);
	t.move(size);
	t.turn(60);
	t.move(size);
	t.turn(60);
	t.move(size);
	t.turn(60);
	t.move(size);
	t.turn(60);
	t.move(size);	
      }
    }

/*

The End

Candidate Number - J1918

*/
