/*

Dissertation - "Using Java To Implement Constraint Satisfaction Systems"
========================================================================

The Queue Class
---------------

Compatible With Java Version 1.1.3

Used by the DeltaBlue algorithm.

Function - implements a "queue" whereby objects are added to the end of the
queue and removed from the front (i.e. in a FIFO order).

*/

class Queue
{
  public QueueSection removerSection, adderSection;
  public int oldest = 0, next = 0;
  public int newSectionSize;
  public int removerSectionSize, adderSectionSize;

  Queue(int firstSectionSize, int newSectionSize)
  {
    this.newSectionSize = newSectionSize;
    removerSection = new QueueSection(firstSectionSize, null);
    removerSectionSize = removerSection.cells.length;
    removerSection.nextSection = removerSection;
    adderSection = removerSection;
    adderSectionSize = adderSection.cells.length;
  }

  Queue(int firstSectionSize)
  { this(firstSectionSize, 500); }

  Queue()
  { this(10); }

  public boolean isEmpty()
  { return (removerSection == adderSection && oldest == next); }

  public void add(Object obj)
  {
    if (next == adderSectionSize) {
      // ** no room in current adder section
      QueueSection oldAdderSection = adderSection;
      next = 0; // new element will go in 0 position
      if (oldAdderSection.nextSection != removerSection) {
        // ** next section is free to become an adder section
        adderSection = oldAdderSection.nextSection;
        adderSectionSize = adderSection.cells.length;
      } else {
        // ** next section is the remover section - so best create a new one
        adderSection = new QueueSection(newSectionSize, removerSection);
        adderSectionSize = adderSection.cells.length;
        oldAdderSection.nextSection = adderSection;
      }
    } else {
      // ** still room for object in current adder section
    }
    // add object to section and move "next" along one
    adderSection.cells[next++] = obj;   
  }

  public Object remove()
  {
    Object popObject = removerSection.cells[oldest];

    if (oldest == removerSectionSize - 1) {
      // ** removing last object from a section
      QueueSection oldRemoverSection = removerSection;
      removerSection = oldRemoverSection.nextSection;
      removerSectionSize = removerSection.cells.length;
      oldest = 0;
    } else {
      // ** removing an element from a section but leaving others still there
      oldest++;
    }

    return popObject;
  }

  class QueueSection
  {
    Object [] cells;
    QueueSection nextSection;
    
    QueueSection(int size, QueueSection nextSection)
    {
      cells = new Object[size];
      this.nextSection = nextSection;
    }
  }
}


/*

The End

*/
