/*

Dissertation - "Using Java To Implement Constraint Satisfaction Systems"
========================================================================

Benchmark Program For A DeltaBlue Implementstion
------------------------------------------------

Compatible With Java Version 1.1.3

(Looks for DeltaBlue.class to do the tests on)

*/

public class Benchmark
{
  public static void main(String [] args)
  {
    Integer num;
    try{ num = Integer.valueOf(args[0]); }
    catch (Exception e) { num = new Integer(10000); }

    new BenchmarkTests(num.intValue());
  }
}

class BenchmarkTests
{
  private DeltaBlue db = new DeltaBlue();

  BenchmarkTests(int numberOfCons)
  {
    chain(numberOfCons);
  }

  public void chain(int numberOfCons)
  {
    System.out.println("Performing a Chain Benchmark with " + numberOfCons +
		       " constraints...");

    Variable [] vars = new Variable[numberOfCons];
    vars[0] = new Variable(0);
    Constraint [] cons = new Constraint[numberOfCons];
    Constraint c;

    //stay constraint to make the methods propagate from last to first variable
    Variable [] argumentVars = new Variable[1];
    argumentVars[0] = vars[0];
    cons[0] = new BMStayCon(argumentVars, DeltaBlue.WEAKEST + 1, false);

    // equality constraints which link all the variables together
    argumentVars = new Variable[2];
    for (int i = 1; i < numberOfCons; i++) {
      vars[i] = new Variable(i);
      argumentVars[0] = vars[i - 1];
      argumentVars[1] = vars[i];
      cons[i] = new BMEqualityCon(argumentVars, DeltaBlue.REQUIRED, false);
    }

    // constraint to be added to reverse the flow - this addition is timed
    argumentVars[0] = vars[numberOfCons - 1];
    c = new BMSetCon(argumentVars, DeltaBlue.REQUIRED - 1, true, -1);

    for (int i = 0; i < numberOfCons; i++) {
      db.addConstraint(cons[i]);
    }

    long timeL, timeC, timeA, timeB, time0, time1;
    Constraint [] inputCons = new Constraint[1];
    Plan pl;

    inputCons[0] = c;

    timeL = 0;
    timeC = 0;

    for(int i = 0; i < 11; i++) {
      System.gc();

      time0 = System.currentTimeMillis();
      db.addConstraint(c);
      pl = db.extractPlan(inputCons);
      time1 = System.currentTimeMillis();

      timeA = time1 - time0;

      System.gc();

      time0 = System.currentTimeMillis();
      db.executePlan(pl);
      time1 = System.currentTimeMillis();

      timeB = time1 - time0;

      if (i > 0) {
	timeL += timeA;
	timeC += timeB;
	displayTimes(timeA, timeB);
      }


      db.removeConstraint(c);
    }
    System.out.println("Averages Over 10 Iterations...");
    displayTimes(timeL/10, timeC/10);
  }

  public void displayTimes(long timeL, long timeC)
  {
    System.out.println("Latency = " + timeL + ", Cycle = " + timeC);
  }
} 

class BMStayCon extends Constraint
{
  BMStayCon(Variable [] vars, int strength, boolean inputFlag)
  {
    this.vars = vars;
    this.strength = strength;
    this.inputFlag = inputFlag;

    methods = new Method[1];
    methods[0] = new BMStayMethod(vars[0]);
  }
}

class BMStayMethod extends Method
{
  BMStayMethod(Variable output)
  { this.output = output; }

  public int code()
  { return output.value; }
}

class BMEqualityCon extends Constraint
{
  BMEqualityCon(Variable [] vars, int strength, boolean inputFlag)
  {
    this.vars = vars;
    this.strength = strength;
    this.inputFlag = inputFlag;

    methods = new Method[2];
    methods[0] = new BMEqualityMethod0(vars);
    methods[1] = new BMEqualityMethod1(vars);
  }
}

class BMEqualityMethod0 extends Method
{
  private Variable [] vars;

  BMEqualityMethod0(Variable [] vars)
  { this.vars = vars; this.output = vars[0]; }

  public int code()
  { return vars[1].value; }
}

class BMEqualityMethod1 extends Method
{
  private Variable [] vars;

  BMEqualityMethod1(Variable [] vars)
  { this.vars = vars; this.output = vars[1]; }

  public int code()
  { return vars[0].value; }
}

class BMSetCon extends Constraint
{
  BMSetCon(Variable [] vars, int strength, boolean inputFlag, int setValue)
  {
    this.vars = vars;
    this.strength = strength;
    this.inputFlag = inputFlag;

    methods = new Method[1];
    methods[0] = new BMSetMethod(vars[0], setValue);
  }
}  

class BMSetMethod extends Method
{
  private int setValue;

  BMSetMethod(Variable output, int setValue)
  { this.output = output; }

  public int code()
  { return setValue; }
}

/*

The End

*/
